# ==============================================
# HDGL SDR Windows Setup Script (PowerShell)
# ==============================================

# Step 0: Set up environment
$Env:HDGL_DLL_PATH = "$env:USERPROFILE\Documents\Turing-Complete\hdgl_sdr_dlls"
New-Item -ItemType Directory -Force -Path $Env:HDGL_DLL_PATH

# Step 1: Download precompiled DLLs (Osmocom Windows binaries)
$rtl_sdr_zip = "$Env:HDGL_DLL_PATH\rtl-sdr.zip"
Invoke-WebRequest -Uri "https://osmocom.org/attachments/download/1557/Release-RTL-SDR.zip" -OutFile $rtl_sdr_zip

# Step 2: Extract DLLs
Add-Type -AssemblyName System.IO.Compression.FileSystem
[System.IO.Compression.ZipFile]::ExtractToDirectory($rtl_sdr_zip, $Env:HDGL_DLL_PATH)

# Step 3: Copy DLLs to PATH (or Python env)
Copy-Item "$Env:HDGL_DLL_PATH\bin\librtlsdr.dll" "$Env:HDGL_DLL_PATH\librtlsdr.dll" -Force
Copy-Item "$Env:HDGL_DLL_PATH\bin\libusb-1.0.dll" "$Env:HDGL_DLL_PATH\libusb-1.0.dll" -Force

# Step 4: Add folder to user PATH temporarily
$env:PATH = "$Env:HDGL_DLL_PATH;$env:PATH"

# Step 5: Test Python import
py -c "from rtlsdr import RtlSdr; sdr = RtlSdr(); print('RTL-SDR detected:', sdr.vendor, sdr.product); sdr.close()"
